-- Let's get a star shower
local shower = Def.ActorFrame{
   InitCommand = function(self) 
      self:SetDrawByZPosition(true);
      --self:spring(3):addrotationy(230)
   end
};

for i=1,30 do
   shower[#shower+1] = Def.Sprite{
      Texture="star.png",
      OnCommand=function(self)
      -- start_z is [1,2] controls 
      local start_z = 1 * math.random() + 1
      local start_x = (-1 * start_z * math.random() * _screen.w)
      local start_y = math.random() * _screen.h
      self:xy(start_x,start_y):zoom(start_z-1):diffusealpha(0.8):z(start_z):rotationz(360*math.random())
      self:linear(3.67 - (start_z-1) * 2):x(start_x + _screen.w*3):addrotationz(180*(start_z -1.5)):addz(-20)
      self:spring(2):addrotationx(120):addrotationy(40)
      end
      }
end

-- a Lua file can only return one Actor
-- so the common strategy is to return one ActorFrame that contains many sub-Actors
return Def.ActorFrame{
   -- keep-alive Actor
   -- this will allow the file to persist for 999 seconds
   -- (or, until the end of the stepchart)
   Def.Actor{ OnCommand=function(self) self:sleep(10) end },
   shower

}
